function sig_out = compute_signals(sig_in,IRs)
%---------------------------%
%     Function inputs       %
%---------------------------%

%\ 'sig_in' ... (samples x numSources) Dry non-reverberant signals in time domain
%\ 'IRs' ... (samples x numMics x numSources) The impulse responses 

%---------------------------%
%     Function outputs      %
%---------------------------%

%\ sig_out ... (samples x numMics x numSources) Signals received at the microphones 

%=============================================%

numMics = size(IRs,2);
numSources = size(IRs,3);

sig_out = zeros(size(sig_in,1),numMics);

for s_idx = 1:numSources
    for m_idx = 1 : numMics
        sig_out(:,m_idx,s_idx) = filter(IRs(:,m_idx,s_idx),1,sig_in(:,s_idx));  
    end
end


 