function IRs = computeIRs(c, Fs, room_size, source, mic_pos, T60,  varargin)

%---------------------------%
%     Function inputs       %
%---------------------------%

%\ 'c' ... Speed of sound
%\ 'Fs' ... Sampling frequency [Hz]
%\ 'room_size' ... (1x3) length x width x height of the room [m]
%\ 'source' ... (3 x numberOfSources), source positions
%\ 'mic_pos' ...(3 x microphonesPerArray), microphone positions [m]
%\ 'T60' ... Reverberation time [s]
%\ varargin{1} ... Reflection order. If not provided, the default is -1.
%\ varargin{2} ... a string naming the directivity pattern, see rir_generator.pdf
%\ varargin{3} ... look direction of a directive microphone 

%---------------------------%
%     Function outputs      %
%---------------------------%

%\ IRs ... The computed impulse responses(samples x numMics x numSources)

%=============================================%

if nargin<7
    refOrder = -1;
else
    refOrder = varargin{1};
end

if nargin<8
    micPattern = 'omnidirectional';
    micLookDir = [0 0];
else
    micPattern = varargin{2};
    micLookDir = varargin{3};
end

% need to map them correctly because here the (0,0) is in the left bottom
% corner whereas in the input we consider (0,0) to be the center.

room_center_xy = room_size(1:2)/2;
source(1:2,:) = source(1:2,:) + repmat(room_center_xy(1:2).',1,size(source,2));

allmics = reshape(mic_pos,[size(mic_pos,1),size(mic_pos,2)*size(mic_pos,3)]);

allmics(1,:) = mic_pos(1,:) + room_center_xy(1);
allmics(2,:) = mic_pos(2,:) + room_center_xy(2);


for sidx = 1:size(source,2)  
      IRs(:,:,sidx) =  rir_generator(c, Fs, allmics.' ,source(:,sidx)',room_size, T60, T60*Fs, micPattern, refOrder, length(room_size), micLookDir);
end

IRs = permute(IRs,[2 1 3]); % IRs: samples x mics x source 

