function varargout = APLab_pitch(varargin)
% APLAB_PITCH MATLAB code for APLab_pitch.fig
%      APLAB_PITCH, by itself, creates a new APLAB_PITCH or raises the existing
%      singleton*.
%
%      H = APLAB_PITCH returns the handle to a new APLAB_PITCH or the handle to
%      the existing singleton*.
%
%      APLAB_PITCH('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in APLAB_PITCH.M with the given input arguments.
%
%      APLAB_PITCH('Property','Value',...) creates a new APLAB_PITCH or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before APLab_pitch_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to APLab_pitch_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help APLab_pitch

% Last Modified by GUIDE v2.5 10-Jan-2014 12:36:00

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @APLab_pitch_OpeningFcn, ...
                   'gui_OutputFcn',  @APLab_pitch_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Update plots for original data at recording
function recordTimer_updatePlots(hRecorderObj,event,hGui,handles)

config=getappdata(handles.figure1,'config');
data=getappdata(handles.figure1,'data');
plots=getappdata(handles.figure1,'plots');
%audioData=getaudiodata(hRecorderObj);
%nSamples=length(audioData);
%data.timeSigOrig(1:nSamples)=audioData;
data.timeSig(min(round(data.recordCounter*config.updateInterval*config.Fs+1),config.recordLengthSamples))=1;
data.recordCounter=data.recordCounter+1;
set(plots.timeSig,'YData',data.timeSig);
setappdata(handles.figure1,'data',data);

% --- Executes just before APLab_pitch is made visible.
function APLab_pitch_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to APLab_pitch (see VARARGIN)

% Choose default command line output for APLab_pitch
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

addpath([pwd filesep 'yin']);
addpath([pwd filesep 'export_fig']);
config.recordLength=5;
config.updateInterval=0.1;
config.Fs=16000;
config.FsRecording=16000;
config.winLen=1/50;
config.winLenSamples=round(config.Fs*config.winLen);
config.winHop=1/100;
config.hopSamples=round(config.winHop*config.Fs);
config.maxSpecF=600; 
config.recordLengthSamples=config.recordLength*config.Fs;
config.fftLen=2048;
config.fftHop=256;
config.fftOvlp=config.fftLen-config.fftHop;
config.nSpecPlotTicks=6;
config.specPlotTick=round(0:((config.fftLen/config.Fs)*(config.maxSpecF/config.nSpecPlotTicks)):(config.fftLen/config.Fs*config.maxSpecF));
config.p.minf0=50;
config.p.maxf0=600;
config.p.thresh=0.1;
config.p.relfag=1;
config.p.hop=config.hopSamples;
config.p.sr=config.Fs;
config.p.wsize=config.winLenSamples;
config.p.lpf=config.Fs/4;
config.p.shift=0;
config.p.range=[1 config.recordLengthSamples];


for k = 0:config.nSpecPlotTicks
   config.specPlotTickLabel{k+1}=[num2str(k*config.maxSpecF/config.nSpecPlotTicks) ' Hz']; 
end


audio.recorder=[];
audio.player=[];
devinfo=audiodevinfo;
if isempty(devinfo.input)
   audio.recDevice=0; 
else
   audio.recDevice=1;
end
if isempty(devinfo.output)
   audio.playDevice=0;
else
   audio.playDevice=1;
end

if audio.recDevice==1
  audio.recorder=audiorecorder(config.FsRecording,16,1,0);
  audio.recorder.TimerPeriod=config.updateInterval;
  audio.recorder.TimerFcn={@recordTimer_updatePlots,hObject,handles};
end
audio.playEnabled=0;

cmap=load('private/cmap.mat');
colormap(cmap.cmp)
data.timeSig=zeros(config.recordLengthSamples,1);
data.recordCounter=0;
data.fname=[];
data.spec=abs(spectrogram(data.timeSig,config.fftLen,config.fftOvlp,config.fftLen,config.Fs));
data.f0_yin=NaN*ones(config.recordLengthSamples,1);
data.f0_lab=NaN*ones(config.recordLengthSamples,1);
data.f0_pos=[];

plots.timeSig=plot(handles.axes_timeSig,data.timeSig,'Color',[241 126 19]/256);
plots.spec=imagesc(data.spec,'Parent',handles.axes_spectrogram);
plots.yinLine=plot(handles.axes_f0_estimate,data.f0_yin,...
    'LineStyle','-','LineWidth',0.5,'Color',[14 56 180]/256);
hold on;
plots.yinMarker=plot(handles.axes_f0_estimate,data.f0_yin,...
    'LineStyle','none','LineWidth',2,'Color',[14 56 180]/256,'Marker','x','MarkerSize',6);
plots.labLine=plot(handles.axes_f0_estimate,data.f0_lab,...
    'LineStyle','-','LineWidth',0.5,'Color',[128 126 64]/256);
plots.labMarker=plot(handles.axes_f0_estimate,data.f0_lab,...
    'LineStyle','none','LineWidth',2,'Color',[128 126 64]/256,'Marker','o','MarkerSize',6);
legend([plots.labMarker,plots.yinMarker],'lab implementation','reference','Location','SouthWest');
plots.h_ax_time=handles.axes_timeSig;
plots.h_ax_f0=handles.axes_f0_estimate;
plots.h_ax_spec=handles.axes_spectrogram;
set(handles.axes_timeSig,...
    'YLim',[-1 1],...
    'XLim',[0 config.recordLengthSamples],...
    'XTickLabel',{'0';'1';'2';'3';'4';'5'},...
    'XTick',0:config.recordLengthSamples/5:config.recordLengthSamples,...
    'YAxisLocation','right');

set(handles.axes_f0_estimate,...
    'YLim',[1 config.maxSpecF],...
    'XLim',[0 config.recordLengthSamples],...
    'XTickLabel',{'0';'1';'2';'3';'4';'5'},...
    'XTick',0:config.recordLengthSamples/5:config.recordLengthSamples,...
    'Color','none',...
    'YTick',[],...
    'YAxisLocation','right');

set(handles.axes_spectrogram,...
    'YLim',[1 config.specPlotTick(end)],'YDir','normal',...
    'XTick',[],...
    'YTick',config.specPlotTick(1:end),...
    'YTickLabel',config.specPlotTickLabel(1:end),...
    'Color','none',...
    'YAxisLocation','right');

plots.h_zoom=zoom(handles.figure1);
set(plots.h_zoom,'enable','on','motion','horizontal');
set(plots.h_zoom,'ActionPostCallback',@h_zoom_postcallback);
gui.record_icon=iconRead('private/record.bmp');
gui.play_icon=iconRead('private/play.bmp');
gui.zoom_in_icon=iconRead('private/vert_zoom_in.png');
gui.zoom_out_icon=iconRead('private/vert_zoom_out.png');
gui.logo=iconRead('private/al_logo.bmp');


set(handles.pb_logo,'CData',gui.logo,'String',[],'Enable','inactive');

set(handles.pb_record,'String',[],...
    'CData',gui.record_icon);
if audio.recDevice==0
   set(handles.pb_record,'Enable','off'); 
end
set(handles.pb_play,'String',[],...
    'CData',gui.play_icon,...
    'Enable','off');
set(handles.pb_time_vert_zoom_in,'String',[],...
    'CData',gui.zoom_in_icon);
set(handles.pb_time_vert_zoom_out,'String',[],...
    'CData',gui.zoom_out_icon);

set(handles.txt_filename,'String',[]);
set(handles.txt_fs,'String',[num2str(config.Fs) ' Hz']);
set(handles.edt_hop_ms,'String',num2str(ceil(config.winHop*1000)));
set(handles.edt_winLen_ms,'String',num2str(ceil(config.winLen*1000)));
set(handles.edt_hop_samples,'String',num2str(config.hopSamples));
set(handles.edt_winLen_samples,'String',num2str(config.winLenSamples));

setappdata(hObject,'config',config);
setappdata(hObject,'audio',audio);
setappdata(hObject,'data',data);
setappdata(hObject,'plots',plots);
setappdata(hObject,'gui',gui);

% UIWAIT makes APLab_pitch wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = APLab_pitch_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



% --- Executes on button press in pb_record.
function pb_record_Callback(hObject, eventdata, handles)
% hObject    handle to pb_record (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
audio=getappdata(handles.figure1,'audio');
config=getappdata(handles.figure1,'config');
plots=getappdata(handles.figure1,'plots');
data=getappdata(handles.figure1,'data');
data.timeSig(1:end)=0;
data.spec=abs(spectrogram(data.timeSig,config.fftLen,config.fftOvlp,config.fftLen,config.Fs));
data.f0_yin=NaN*ones(config.recordLengthSamples,1);
data.f0_lab=NaN*ones(config.recordLengthSamples,1);
data.f0_pos=[];
set(plots.yinLine,'YData',data.f0_yin,'XData',data.f0_pos);
set(plots.labLine,'YData',data.f0_lab,'XData',data.f0_pos);
set(plots.yinMarker,'YData',data.f0_yin,'XData',data.f0_pos);
set(plots.labMarker,'YData',data.f0_lab,'XData',data.f0_pos);
set(plots.spec,'CData',data.spec);
set(plots.timeSig,'YData',data.timeSig);
data.recordCounter=0;
setappdata(handles.figure1,'data',data);
recorder=audio.recorder
record(recorder,config.recordLength);
while isrecording(recorder)
    pause(0.5);
end
recordData=getaudiodata(recorder);
recLength=length(recordData);
insLen=min(recLength,config.recordLengthSamples);
data.timeSig(1:insLen)=recordData(1:insLen);
if audio.playDevice == 1
   audio.player=audioplayer(data.timeSig,config.Fs);
   set(handles.pb_play,'Enable','on');
end
%data.players.orig=audioplayer(data.timeSigOrig,config.Fs);
%set(data.players.orig,'StopFcn',{@orig_play_stop,handles});
set(plots.timeSig,'YData',data.timeSig);
data.spec=abs(spectrogram(data.timeSig,config.fftLen,config.fftOvlp,config.fftLen,config.Fs));
set(plots.spec,'CData',data.spec);

config.Fs=config.FsRecording;
data.fname='recorded data';
set(handles.txt_filename,'String','recorded data');
set(handles.txt_fs,'String',num2str(config.Fs));


setappdata(handles.figure1,'data',data);
setappdata(handles.figure1,'plots',plots);
setappdata(handles.figure1,'config',config);
setappdata(handles.figure1,'audio',audio);

% --- Executes on button press in pb_openFile.
function pb_openFile_Callback(hObject, eventdata, handles)
% hObject    handle to pb_openFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
config=getappdata(handles.figure1,'config');
plots=getappdata(handles.figure1,'plots');
data=getappdata(handles.figure1,'data');
audio=getappdata(handles.figure1,'audio');
fname=uigetfile('audiofiles/*.wav');
if fname~=0
    data.fname=fname;
    data.timeSig(1:end)=0;
    data.spec=abs(spectrogram(data.timeSig,config.fftLen,config.fftOvlp,config.fftLen,config.Fs));
    set(plots.spec,'CData',data.spec);
    set(plots.timeSig,'YData',data.timeSig);
    data.recordCounter=0;
    setappdata(handles.figure1,'data',data);
    %info=audioinfo(data.fname);
    [tmp,fs]=wavread(['audiofiles/' data.fname]);
    config.Fs = fs;
    nSamplesToRead=min(length(tmp),config.recordLengthSamples);
    data.timeSig(1:nSamplesToRead)=tmp(1:nSamplesToRead);
    if audio.playDevice == 1
        audio.player=audioplayer(data.timeSig,config.Fs);
        set(handles.pb_play,'Enable','on');
    end
    set(handles.txt_filename,'String',data.fname);
    set(handles.txt_fs,'String',[num2str(config.Fs) ' Hz']);
    set(plots.timeSig,'YData',data.timeSig);
    data.spec=abs(spectrogram(data.timeSig,config.fftLen,config.fftOvlp,config.fftLen,config.Fs));
    set(plots.spec,'CData',data.spec);
    data.f0_yin=NaN*ones(config.recordLengthSamples,1);
    data.f0_lab=NaN*ones(config.recordLengthSamples,1);
    data.f0_pos=[];
    set(plots.yinLine,'YData',data.f0_yin,'XData',data.f0_pos);
    set(plots.labLine,'YData',data.f0_lab,'XData',data.f0_pos);
    set(plots.yinMarker,'YData',data.f0_yin,'XData',data.f0_pos);
    set(plots.labMarker,'YData',data.f0_lab,'XData',data.f0_pos);
end
setappdata(handles.figure1,'data',data);
  setappdata(handles.figure1,'audio',audio);
  setappdata(handles.figure1,'config',config');

% --- Executes on button press in pb_estimate_f0.
function pb_estimate_f0_Callback(hObject, eventdata, handles)
% hObject    handle to pb_estimate_f0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
config=getappdata(handles.figure1,'config');
plots=getappdata(handles.figure1,'plots');
data=getappdata(handles.figure1,'data');
set(gcf,'pointer','watch');
data.timeSig=data.timeSig(:);
nx = length(data.timeSig);
ncol = fix((nx-config.winLenSamples)/config.hopSamples+1);
data.f0_pos=config.winLenSamples/2+(0:(ncol-1))*config.hopSamples;
colindex = 1 + (0:(ncol-1))*config.hopSamples;
rowindex = (1:(config.winLenSamples))';
win=hanning(config.winLenSamples);
y = zeros(config.winLenSamples,ncol);
y(:) = data.timeSig(rowindex(:,ones(1,ncol))+colindex(ones(config.winLenSamples,1),:)-1);%.*win(:,ones(1,ncol));

yin1=NaN*ones(ncol,1);
lab=NaN*ones(ncol,1);

for k=1:ncol
   lab(k)=f0_estimate(y(:,k),config.Fs);
end
r=yin(data.timeSig,config.p);
yin2=2.^(r.f0+log2(440))';
yin2=yin2(1:ncol);
data.f0_lab=lab;
data.f0_yin=yin2;
set(plots.yinLine,'YData',data.f0_yin,'XData',data.f0_pos);
set(plots.labLine,'YData',data.f0_lab,'XData',data.f0_pos);
set(plots.yinMarker,'YData',data.f0_yin,'XData',data.f0_pos);
set(plots.labMarker,'YData',data.f0_lab,'XData',data.f0_pos);
set(gcf,'pointer','arrow');
setappdata(handles.figure1,'data',data);
setappdata(handles.figure1,'plots',plots);
setappdata(handles.figure1,'config',config);



function edt_winLen_ms_Callback(hObject, eventdata, handles)
% hObject    handle to edt_winLen_ms (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edt_winLen_ms as text
%        str2double(get(hObject,'String')) returns contents of edt_winLen_ms as a double
config=getappdata(handles.figure1,'config');
plots=getappdata(handles.figure1,'plots');
data=getappdata(handles.figure1,'data');
newWinLen=str2num(get(handles.edt_winLen_ms,'String'))/1000;
if newWinLen ~= config.winLen
    config.winLen=newWinLen;
    config.winLenSamples=round(config.Fs*config.winLen);
    set(handles.edt_winLen_ms,'String',num2str(ceil(config.winLen*1000)));
    set(handles.edt_winLen_samples,'String',num2str(config.winLenSamples));
end
setappdata(handles.figure1,'data',data);
setappdata(handles.figure1,'plots',plots);
setappdata(handles.figure1,'config',config);

% --- Executes during object creation, after setting all properties.
function edt_winLen_ms_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edt_winLen_ms (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edt_hop_ms_Callback(hObject, eventdata, handles)
% hObject    handle to edt_hop_ms (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edt_hop_ms as text
%        str2double(get(hObject,'String')) returns contents of edt_hop_ms as a double

config=getappdata(handles.figure1,'config');
plots=getappdata(handles.figure1,'plots');
data=getappdata(handles.figure1,'data');
newHop=str2num(get(handles.edt_hop_ms,'String'))/1000;
if newHop ~= config.winHop
    config.winHop=newHop;
    config.hopSamples=round(config.Fs*config.winHop);
    set(handles.edt_hop_samples,'String',num2str(config.hopSamples));
    set(handles.edt_hop_ms,'String',num2str(ceil(config.winHop*1000)));
end
setappdata(handles.figure1,'data',data);
setappdata(handles.figure1,'plots',plots);
setappdata(handles.figure1,'config',config);

    
    
% --- Executes during object creation, after setting all properties.
function edt_hop_ms_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edt_hop_ms (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pb_print.
function pb_print_Callback(hObject, eventdata, handles)
% hObject    handle to pb_print (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
config=getappdata(handles.figure1,'config');
plots=getappdata(handles.figure1,'plots');
data=getappdata(handles.figure1,'data');
dlg_ans=inputdlg('Item Name','Item Name',1,{data.fname});
if ~isempty(dlg_ans)
    fig=createplot_f0(dlg_ans{1},data.timeSig,data.f0_pos,[data.f0_lab(:)  data.f0_yin(:) data.f0_lab(:)  data.f0_yin(:)]);
end

function edt_winLen_samples_Callback(hObject, eventdata, handles)
% hObject    handle to edt_winLen_samples (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edt_winLen_samples as text
%        str2double(get(hObject,'String')) returns contents of edt_winLen_samples as a double
config=getappdata(handles.figure1,'config');
plots=getappdata(handles.figure1,'plots');
data=getappdata(handles.figure1,'data');
newWinLen=str2num(get(handles.edt_winLen_samples,'String'));
if newWinLen ~= config.winLenSamples
    config.winLenSamples=newWinLen;
    config.winLen=config.winLenSamples/config.Fs;
    set(handles.edt_winLen_ms,'String',num2str(ceil(config.winLen*1000)));
    set(handles.edt_winLen_samples,'String',num2str(config.winLenSamples));
end
setappdata(handles.figure1,'data',data);
setappdata(handles.figure1,'plots',plots);
setappdata(handles.figure1,'config',config);

% --- Executes during object creation, after setting all properties.
function edt_winLen_samples_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edt_winLen_samples (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pb_export_data.
function pb_export_data_Callback(hObject, eventdata, handles)
% hObject    handle to pb_export_data (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
export.config=getappdata(handles.figure1,'config');
plots=getappdata(handles.figure1,'plots');
export.data=getappdata(handles.figure1,'data');
dlg_ans=inputdlg('variable name','variable name',1,{'f0_data'});
if ~isempty(dlg_ans)
   assignin('base',dlg_ans{1},export);
end
   


function edt_hop_samples_Callback(hObject, eventdata, handles)
% hObject    handle to edt_hop_samples (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edt_hop_samples as text
%        str2double(get(hObject,'String')) returns contents of edt_hop_samples as a double
config=getappdata(handles.figure1,'config');
plots=getappdata(handles.figure1,'plots');
data=getappdata(handles.figure1,'data');
newHop=str2num(get(handles.edt_hop_samples,'String'));
if newHop ~= config.winHop
    config.hopSamples=newHop;
    config.winHop=config.hopSamples/config.Fs;
    set(handles.edt_hop_samples,'String',num2str(config.hopSamples));
    set(handles.edt_hop_ms,'String',num2str(ceil(config.winHop*1000)));
end
setappdata(handles.figure1,'data',data);
setappdata(handles.figure1,'plots',plots);
setappdata(handles.figure1,'config',config);

% --- Executes during object creation, after setting all properties.
function edt_hop_samples_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edt_hop_samples (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function h_zoom_postcallback(obj,evd)
plots=getappdata(obj,'plots');
data=getappdata(obj,'data');
config=getappdata(obj,'config');
if plots.h_ax_time == evd.Axes
   xlim=get(evd.Axes,'XLim');
   set(plots.h_ax_f0,'XLim',xlim);
end
if plots.h_ax_f0 == evd.Axes
   xlim=get(evd.Axes,'XLim');
   set(plots.h_ax_time,'XLim',xlim);
end
xlim=round(xlim);
len=xlim(2)-xlim(1);
fac=len/length(data.timeSig);
fftOvlp=round(config.fftLen-config.fftHop*fac);
data.spec=abs(spectrogram(data.timeSig(max(1,xlim(1)):min(xlim(2),length(data.timeSig))),config.fftLen,fftOvlp,config.fftLen,config.Fs));
set(plots.spec,'CData',data.spec);
set(plots.h_ax_spec,'XLim',[0 size(data.spec,2)]);

setappdata(obj,'plots',plots);
setappdata(obj,'config',config);
setappdata(obj,'data',data);


% --- Executes on button press in pb_time_vert_zoom_in.
function pb_time_vert_zoom_in_Callback(hObject, eventdata, handles)
% hObject    handle to pb_time_vert_zoom_in (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plots=getappdata(handles.figure1,'plots');
data=getappdata(handles.figure1,'data');
config=getappdata(handles.figure1,'config');
ylim=get(handles.axes_timeSig,'YLim')*0.5;
set(handles.axes_timeSig,'YLim',ylim);
%set(handles.pb_time_vert_zoom_out,'Enable','true');
setappdata(handles.figure1,'plots',plots);
setappdata(handles.figure1,'config',config);
setappdata(handles.figure1,'data',data);

% --- Executes on button press in pb_time_vert_zoom_out.
function pb_time_vert_zoom_out_Callback(hObject, eventdata, handles)
% hObject    handle to pb_time_vert_zoom_out (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
plots=getappdata(handles.figure1,'plots');
data=getappdata(handles.figure1,'data');
config=getappdata(handles.figure1,'config');
ylim=get(handles.axes_timeSig,'YLim')*2;
if ylim(2) >= 1
   ylim=[-1 1];
   %set(handles.pb_time_vert_zoom_out,'Enable','false');
end
set(handles.axes_timeSig,'YLim',ylim);
setappdata(handles.figure1,'plots',plots);
setappdata(handles.figure1,'config',config);
setappdata(handles.figure1,'data',data);


% --- Executes on button press in pb_savePlots.
function pb_savePlots_Callback(hObject, eventdata, handles)
% hObject    handle to pb_savePlots (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
config=getappdata(handles.figure1,'config');
plots=getappdata(handles.figure1,'plots');
data=getappdata(handles.figure1,'data');
dlg_ans=inputdlg({'Item Name','File Name'},'File Name',1,{data.fname,[data.fname '.pdf']});
if ~isempty(dlg_ans)
  fig=createplot_f0(dlg_ans{1},data.timeSig,data.f0_pos,[data.f0_lab(:)  data.f0_yin(:) data.f0_lab(:)  data.f0_yin(:)]);
  %eval(['export_fig ' dlg_ans{2} ' -pdf' ]);
  %eval(['saveas(fig, ''' dlg_ans{2} ''', ''-pdf''' ]);
  saveas(fig, dlg_ans{2}, 'pdf');
  close(fig);
end


% --- Executes on button press in pb_play.
function pb_play_Callback(hObject, eventdata, handles)
% hObject    handle to pb_play (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
audio=getappdata(handles.figure1,'audio');
play(audio.player);

% --- Executes on button press in pb_logo.
function pb_logo_Callback(hObject, eventdata, handles)
% hObject    handle to pb_logo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


