%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Waveform Superposition
%
%  Visualization
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all;

%%
fs = 4410;
%fs = 256;
duration = 4;  %seconds
t=(0:1:(duration*fs-1))/fs;

figure;
subplot(2,2,1)
w=1;theta=0; ampl=1;
f=ampl*sin(2*pi*(w*t-theta));		
plot(t,f)               
axis([0,4,-1.2,1.2])
xlabel('time t')
set(gca,'xtick',[])
title('signal f')
%sound(f,fs);                

subplot(2,2,2)
w=3; theta=0.2; ampl=1;
g=ampl*sin(2*pi*(w*t-theta));
plot(t,g)               
axis([0,4,-1.2,1.2])
xlabel('time t')
set(gca,'xtick',[])
title('signal g')                
%sound(g,fs);   

subplot(2,2,3)
e = randn(1,length(t));	  %white N(0,1)-distributed noise
sigma = 0.3;		      %noise level = Variance of sigma*e
h=sigma*e;                %noisy signal
plot(t,h)               
axis([0,4,-1.2,1.2])
title('signal h')
%sound(h,fs)
  
subplot(2,2,4)
s = f + 0.8*g + 0.5 * h;
plot(t,s)  
axis([0,4,-2.2,2.2])
xlabel('time t')
title('signal f + 0.8 * g + 0.5 * h')
sound(s,fs)
