%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Waveform Sinusoidal
%
% Frequency + Sonification
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all;

fs = 4096;
duration = 1;  %seconds
t=(0:1:(duration*fs-1))/fs;
p = 69;
w = 2^((p-69)/12) * 440;
theta=0; 
ampl=0.1;
% 10 * ampli -> 100 * intensity -> 20 dB increase
f=ampl*sin(2*pi*(w*t-theta));
figure;
plot(t,f)
a = max(abs(f));
axis([0,duration,-1.1*a,1.1*a])
xlabel('time t')
title(['\omega=',num2str(w),', \theta=',num2str(theta), ', A=' num2str(ampl)])

sound(f,fs);

