%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Waveform Sinusoidal
%
% Sonification + dB
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all;

fs = 4096;
duration = 1;  %seconds
t=(0:1:(duration*fs-1))/fs;
w=440;
theta=0; 
ampl=0.1;
% 10 * ampli -> 100 * intensity -> 20 dB increase
f=ampl*sin(2*pi*(w*t-theta));
figure;
plot(t,f)
a = max(abs(f));
axis([0,duration,-1.1*a,1.1*a])

energy = sum(f.^2)/fs;
power = energy/duration;
area = 1;
intensity = power/area;
intensityReference = 10^(-12);
soundLevel = 10 * log10(intensity/intensityReference);

xlabel(['Sound level = ',num2str(soundLevel),' [dB]']);
title(['\omega=',num2str(w),', \theta=',num2str(theta), ', A=' num2str(ampl)])
sound(f,fs);
