%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Frequencies for equal-tempered scale
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


freq_rev = 440; %A4
chromas = [' C';'C#';' D';'D#';' E';' E';'F#';' G';'G#';' A',;'A#';' B'];

pitch = [60:72]; %C4 - C5

octave = floor(pitch/12)-1;
chroma = mod(pitch,12)+1;

freq = (2.^((pitch-69)/12))*440;

fprintf('\n-------------------------\n')
fprintf('Frequency of MIDI pitches\n')
fprintf('-------------------------\n')
for k=1:length(pitch);
     fprintf('%s %1.0f %4.0f  %10.3f \n',chromas(chroma(k),:),octave(k),pitch(k),freq(k));
end

% -------------------------
% Frequency of MIDI pitches
% -------------------------
%  C 4   60     261.626 
% C# 4   61     277.183 
%  D 4   62     293.665 
% D# 4   63     311.127 
%  E 4   64     329.628 
%  E 4   65     349.228 
% F# 4   66     369.994 
%  G 4   67     391.995 
% G# 4   68     415.305 
%  A 4   69     440.000 
% A# 4   70     466.164 
%  B 4   71     493.883 
%  C 5   72     523.251 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Frequencies for harmonics and pure scale 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pitch = 60; %C4
octave = floor(pitch/12)-1;

chroma_harm = [' C';' C';' G';' C';' E';' G';'A#';' C';' D';' E'];
octave_harm_rel = [0 1 1 2 2 2 2 3 3 3];

harm = [1:10];
octave_harm = octave + octave_harm_rel;
freq_fund = (2.^((pitch-69)/12))*440;
freq_harm = freq_fund * harm;
freq_pure = freq_harm./(2.^octave_harm_rel);

fprintf('\n-------------------------\n')
fprintf('Frequency of harmonics\n')
fprintf('-------------------------\n')
for k=1:length(harm);
     fprintf('%s %1.0f %10.3f \n',chroma_harm(k,:),octave_harm(k),freq_harm(k));
end

% -------------------------
% Frequency of harmonics
% -------------------------
%  C 4    261.626 
%  C 5    523.251 
%  G 5    784.877 
%  C 6   1046.502 
%  E 6   1308.128 
%  G 6   1569.753 
% A# 6   1831.379 
%  C 7   2093.005 
%  D 7   2354.630 
%  E 7   2616.256 


fprintf('\n-------------------------\n')
fprintf('Frequency of pure pitches\n')
fprintf('-------------------------\n')
for k=1:length(harm);
     fprintf('%s %1.0f %10.3f \n',chroma_harm(k,:),4,freq_pure(k));
end

% -------------------------
% Frequency of pure pitches
% -------------------------
%  C 4    261.626 
%  C 4    261.626 
%  G 4    392.438 
%  C 4    261.626 
%  E 4    327.032 
%  G 4    392.438 
% A# 4    457.845 
%  C 4    261.626 
%  D 4    294.329 
%  E 4    327.032 
