function [ f, wav_mix ] = generate_sinusoids( frequencies, parameter)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here

if nargin < 2
    parameter = [];
end

if ~isfield(parameter, 'amplitudes')
    parameter.amplitudes = ones(length(frequencies),1)./10;
end

if ~isfield(parameter, 'fs')
    parameter.fs = 44100;
end

if ~isfield(parameter, 'duration') % seconds
    parameter.duration = 1;
end

if ~isfield(parameter, 'save')
    parameter.save = 0;
end

if ~isfield(parameter, 'save_filename')
    parameter.save_filename = 'sinusoid.wav';
end

if ~isfield(parameter, 'sonify')
    parameter.sonify = 0;
end

if ~isfield(parameter, 'mix_sinusoids')
    parameter.mixSinusoids = 1;
end

if ~isfield(parameter, 'theta')
    parameter.theta = 0;
end

t=(0:1:(parameter.duration*parameter.fs-1))/parameter.fs;

f = bsxfun(@times,(sin(2*pi*(frequencies' * t - parameter.theta))), parameter.amplitudes);

%%
if parameter.sonify
    for k=1:size(f,1)
        sound(f(k,:),parameter.fs);
    end
end

%%
if parameter.mixSinusoids
    wav_mix = sum(f)./length(frequencies);
    if parameter.sonify
        sound(wav_mix,parameter.fs);
    end
end

%%
if parameter.save == 1
    wavwrite(f,fs,parameter.save_filename);
end


end

