freq_rev = 440; %A4





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Frequencies for harmonics and pure scale
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% C2 MIDI pitch number = 36
pitch = 36;
% pitch = 60; %C4
octave = floor(pitch/12)-1;

chroma_harm = [' C';' C';' G';' C';' E';' G';'A#';' C';' D';' E'; 'F#'; ' G'; 'Ab'; 'Bb'; ' B'; ' C'];
chroma_harm_cell = {' C';' C';' G';' C';' E';' G';'Ais';' C';' D';' E'; ' Fis'; ' G'; 'Ab'; 'Bb'; ' B'; ' C'};
pitch_dist = [ 0; 12; 12+7; 12+12; 12+12+4; 12+12+7; 12+12+10; 12+12+12; 36+2;36+4;36+6;36+7;36+8;36+10; 36+11; 48];
overtone_midi = (2.^(((pitch+pitch_dist)-69)/12))*freq_rev;
octave_harm_rel = [0 1 1 2 2 2 2 3 3 3 3 3 3 3 3 4];

harm = [1:16];
octave_harm = octave + octave_harm_rel;


freq_fund = (2.^((pitch-69)/12))*440;
freq_harm = freq_fund * harm;
freq_pure = freq_harm./(2.^octave_harm_rel);


paramSinusoid.fs = 44100;
paramSinusoid.duration = 1;
paramSinusoid.amplitudes = ones(length(freq_harm),1)./1.001;
% paramSinusoid.filename = [chroma_harm num2str(octave_harm')];

% Generate harmonic overtone series
[f_harm wav_mix_harm] = generate_sinusoids(freq_harm,paramSinusoid);

% Generate MIDI sinewaves
[f_midi wav_mix_midi] = generate_sinusoids(overtone_midi',paramSinusoid);

fprintf('\n---------------------------------------------------------------------------\n')
fprintf('*** Frequency of harmonics ***\n\n')
fprintf('pitch \t\t harmonics \t\t midi \t\t deviation(cents) \n')
fprintf('---------------------------------------------------------------------------\n')

f_harm_succ = [];
f_midi_succ = [];
f_harm_succ_singleTones = [];
f_midi_succ_singleTones = [];
f_midiHarm_mix_singleTones = [];
for k=1:length(harm);
    fprintf('%s %1.0f \t %10.3f \t %10.3f \t %f \n',chroma_harm(k,:),octave_harm(k),freq_harm(k),overtone_midi(k),1200*log2(freq_harm(k)/overtone_midi(k)));
    filename_harm     = [ 'sinusoid_harmonic_Fund-C2_harmonic' num2str(k,'%02.f') '-' strtrim(chroma_harm_cell{k}) num2str(octave_harm(k))];
    filename_harm_mix = [ 'sinusoidTone_harmonic_Fund-C2-harmonic' num2str(k,'%02.f') '-' strtrim(chroma_harm_cell{k}) num2str(octave_harm(k))];
    filename_midi     = [ 'sinusoid_MIDI_harmonic' num2str(k,'%02.f') '-' strtrim(chroma_harm_cell{k}) num2str(octave_harm(k))];
    filename_midi_mix = [ 'sinusoidTone_MIDI_Fund-C2-harmonic' num2str(k,'%02.f') '-' strtrim(chroma_harm_cell{k}) num2str(octave_harm(k))];
    filename_midi_harm = ['sinusoid_harmonicMIDI_Fund-C2_harmonic' num2str(k,'%02.f') '-' strtrim(chroma_harm_cell{k}) num2str(octave_harm(k))];
    
    
    
    % Harmonic Overtones
    wavwrite(f_harm(k,:), paramSinusoid.fs,filename_harm)
    wavwrite(sum(f_harm(1:k,:),1)/k, paramSinusoid.fs,filename_harm_mix)
    
    % MIDI "overtones"
    wavwrite(f_midi(k,:), paramSinusoid.fs,filename_midi)
    wavwrite(sum(f_midi(1:k,:),1)/k, paramSinusoid.fs,filename_midi_mix)
    
    % MIX stereo
    mix_midiHarm = [f_harm(k,:)' f_midi(k,:)'];
    wavwrite(mix_midiHarm, paramSinusoid.fs,filename_midi_harm)
    f_midiHarm_mix_singleTones = [f_midiHarm_mix_singleTones; [ mix_midiHarm]];
    
    % successive waveforms (harmonic/midi/single tones)
    f_harm_succ = [f_harm_succ sum(f_harm(1:k,:)/k,1)];
    f_midi_succ = [f_midi_succ sum(f_midi(1:k,:)/k,1)];
    f_midi_succ_singleTones = [f_midi_succ_singleTones f_midi(k,:)];
    f_harm_succ_singleTones = [f_harm_succ_singleTones f_harm(k,:)];
    
end


wavwrite(f_midi_succ, paramSinusoid.fs,'sinsoidsuccessive_MIDI.wav');
wavwrite(f_harm_succ, paramSinusoid.fs,'sinsoidsuccessive_harmonics.wav');

wavwrite(f_harm_succ_singleTones, paramSinusoid.fs,'sinsoidsuccessive_harmonics_singlenotes.wav');
wavwrite(f_midi_succ_singleTones, paramSinusoid.fs,'sinsoidsuccessive_midi_singlenotes.wav');
wavwrite(f_midiHarm_mix_singleTones, paramSinusoid.fs,'sinsoidsuccessive_MIX-harmonicMIDI_singlenotes.wav');

wavwrite([sum(f_harm(1:k,:),1)'/length(harm) sum(f_midi(1:length(harm),:),1)'/length(harm)], paramSinusoid.fs,'sinusoid_harmonicMIDI_all.wav');

