%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Sinus overlayed and Fourier transform
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all hidden;

a=0;b=10;N=4096;t = a:(1/N)*(b-a):b-(1/(N*(b-a)));

g=sin(2*pi*t) + 0.7*sin(10*pi*t);
e = randn(1,N);		  %white N(0,1)-distributed noise
sigma = 0.1;		      %noise level = Variance of sigma*e
h=sigma*e;  
g = g+h;


[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,0,10,16);

subplot(2,1,1)
plot(t,g)            
axis([a,b,-2.2,2.2])
xlabel('Time t')
%title('Chirp signal f(t)=sin(50*pi*t^2) on the interval [0:2]')

subplot(2,1,2)
plot(w,abs(ghut(wmin:wmax)))  
%plot(w,abs(ghut(wmin:wmax)).^2)  
xlabel('Frequency \omega')
%title('Spectral energy density |F(f)|^2')  

