%Chirp-Signal und gefensterte Fouriertransformation

figure;
N =2000;               %Samplingrate
a=0;b=1;
t = a:1/N:b;             %Zeitintervall [0,1]
f = sin(400*2*pi*t)+sin(450*2*pi*t); 
f(900)=10;
f(1000)=10;

axes('Position',[0.1,0.8,0.8,0.1])
plot(t,f);
%title('f(t)=sin(800\pi t)+sin(900\pi t), peaks at x=0.45, x=0.5, and WFT with Hanning window of length 0.02') 
axis([a,b,-3,8])
set(gca,'YTick',[0,4,8]);

axes('Position',[0.1,0.1,0.8,0.63])
specgram(f,512,N,hanning(40),30)
xlabel('Time t')
ylabel('Frequency \omega')
%title('Hanning-Fenster der Breite 0.02')
%specgram(f,256,N,boxcar(00),85)
%axis([a,b,0,200])


printPaperPosition = [1   10   22  14]; %[left, bottom, width, height]
printFile = 'fig_WFT_window_small';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));


wavwrite(0.1.*f,2000,16,'superpos_sin_sin_imp_imp.wav')