%Chirp-Signal und gefensterte Fouriertransformation

N =2000;               %Samplingrate
a=0;b=1;
o = 400;						%Frequenz der Chirpfunktion
t = a:1/N:b;             %Zeitintervall [0,1]
f = sin(o*pi*t.*t);     %Chirpfunktion


figure;
axes('Position',[0.1,0.8,0.8,0.1])
plot(t,f)
%title('Chirp function f(t)=sin(400\pi t^2) and WFT with Hanning window of length 0.05')

axis([a,b,-1.4,1.4])

axes('Position',[0.1,0.1,0.8,0.63])
specgram(f,512,N,hanning(100),90)

xlabel('Time t')
ylabel('Frequency \omega')

%colorbar;

printPaperPosition = [1   10   22  14]; %[left, bottom, width, height]
printFile = 'fig_WFT_chirp_hanning';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));


wavwrite(1.*f,N,16,'chirp.wav')