%Chirp-Signal und gefensterte Fouriertransformation

N =2000;               %Samplingrate
a=0;b=1;
o = 400;						%Frequenz der Chirpfunktion
t = a:1/N:b;             %Zeitintervall [0,1]
f = sin(o*pi*t.*t);     %Chirpfunktion

figure
axes('Position',[0.1,0.8,0.8,0.1])
plot(t,f)
%title('Chirp function f(t)=sin(400\pi t^2) and WFT with box window of length 0.05')

axis([a,b,-1.4,1.4])

axes('Position',[0.1,0.1,0.8,0.63])
specgram(f,512,N,boxcar(100),90)

xlabel('Time t')
ylabel('Frequency \omega')


printPaperPosition = [1   10   22  14]; %[left, bottom, width, height]
printFile = 'fig_WFT_chirp_box';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));

                        
