function[w,ghut,wmin,wmax]=m_cft(a,b,N,t,g,c,d,M)
%Approximation of the Continuous Fourier Transformation 

%clear;
%a=0;b=2;             %Signal g:[a,b] -> C
%N=512;               %Anzahl der Samples von g, g(a+((k-1)/N)*(b-a)), k=1,...,N
%M = 4;               %1/(M(b-a)) ist Samplingperiode im Frequenzbereich
%c=-120;d=120;        %Fouriertransformation ghut:[c,d]->C soll berechnet werden 
                      %Fr c und d gelten dabei die Grenzen
                      % -min/(M(b-a))< c < d < max/(M(b-a))
                      % min=MN-abbrunden(MN/2), max=MN-abbrunden(MN/2)-1
                                                
                        
    
                        
                        %t = a:(1/N)*(b-a):b-(1/(N*(b-a))); 
                        %Zeitachse, Intervall [a,b-1/(N(b-a))] in N Punkte unterteilt
                        
kmin=ceil(c*M*(b-a));		
kmax=floor(d*M*(b-a));
w = kmin/(M*(b-a)):1/(M*(b-a)):kmax/(M*(b-a));
						%Frequenzachse, so da durch die vorgegebene Samplingperiode
						%1/(M*(b-a)) im Frequenzbereich das Intervall [c:d]
                        %optimal unterteilt wird.
                        
%g=sin(50*pi*t.*t);		
                        %Funktion g:[a,b] -> C
						%Der Vektor g wird interpretiert als eine normalisierte 
   						%Funktion f:[0,1] -> C, f(t)=g((t+(a/(b-a)))(b-a))

v=[g,zeros(1,N*(M-1))];  
                        %Hinzufgen von (M-1)*N Nullen

vhut = 1/N*fft(v);      %FFT des Vektors v
                        %Interpretation von vhut als die Approximation 
                        %von fhut durch Riemannsummen 
                        
for l=1:M*N,       
	ghut(l)=vhut(l)*exp(-2*pi*i*((l-1)/M)*a/(b-a))*(b-a);
end
						%Normalisierung von g nach f im Frequenzbereich
                        %rckgngig machen
                        
pos=ghut(1:floor(M*N/2)); 	    %positive Frequenzen
neg=ghut(floor(M*N/2)+1:M*N);   %negative Frequenzen                     
ghut=[neg,pos]; 				%die hchsten Frequenzen werden aufgrund
								%des Aliasing-Effektes als negative 
								%Frequenzen interpretiert
freqnull=(M*N-floor(M*N/2)+1);  %ghut(freqnull) ist nun der Wert der 
                                %Fouriertransformierten an der Frequenz w=0                               
wmin=freqnull+kmin;
wmax=freqnull+kmax;
								%plot(w,ghut(wmin:wmax))
                            
                        
                        
                        
                        